#include <stdlib.h>
#include <dos.h>
#include "sounddrv.h"

#define INTMIN	0x80
#define INTMAX	0xBF
#define IDSTR  0x444E5344l
#define IDOFS	0x0000
 
static int nint;

/* DSOUND */

static int GetInt(void)
{
	int n;
	void *pt;

	for(n=INTMIN;n<=INTMAX;n++)
		if ( (pt=getvect(n))!=NULL && *(DWORD *)MK_FP(FP_SEG(pt),IDOFS)==IDSTR ) 
			return n;
	return -1;
}

int InitDSound()
{
	struct REGPACK r;

	nint=GetInt();
	if (nint<0) return DSER_NODRIVER;
	return 0;
}

int StartDSound(DSOUNDINFO *SD)
{
	struct REGPACK r;
	r.r_ax=1;
	r.r_bx=FP_OFF(SD);
	r.r_es=FP_SEG(SD);
	intr(nint,&r);
	return r.r_ax;
}

int StopDSound(void)
{
	struct REGPACK r;
	r.r_ax=2;
	intr(nint,&r);
	return r.r_ax;
}

int StartDSoundIN(DSOUNDINFO *SD)
{
	struct REGPACK r;
	r.r_ax=3;
	r.r_bx=FP_OFF(SD);
	r.r_es=FP_SEG(SD);
	intr(nint,&r);
	return r.r_ax;
}
	
int StopDSoundIN(void)
{
	struct REGPACK r;
	r.r_ax=4;
	intr(nint,&r);
	return r.r_ax;
}

int GetDSoundStatus(void)
{
	struct REGPACK r;
	r.r_ax=5;
	intr(nint,&r);
	return r.r_ax;
}

int GetCardInfo(CARDINFO *CINF)
{
	struct REGPACK r;
	r.r_ax=6;
	r.r_bx=FP_OFF(CINF);
	r.r_es=FP_SEG(CINF);
	intr(nint,&r);
	return r.r_ax;
}

void GetCardGlobalInfo(CARDGLOBALINFO *CGINF)
{
	struct REGPACK r;
	r.r_ax=7;
	r.r_bx=FP_OFF(CGINF);
	r.r_es=FP_SEG(CGINF);
	intr(nint,&r);
}

WORD GetAccurateFreq(WORD ctype,DWORD cdata,WORD freq)
{
	struct REGPACK r;
	r.r_ax=8;
	r.r_bx=ctype;
	r.r_cx=(WORD)cdata;
	r.r_dx=(WORD)(cdata>>16);
	r.r_si=freq;
	intr(nint,&r);
	return r.r_ax;
}

void EndDSound(void)
{
	struct REGPACK r;
	r.r_ax=9;
	intr(nint,&r);
}

void SetDSMemProc(void * far pascal (*mygetmem)(WORD len),void far pascal (*myfreemem)(void *p,WORD len))
{
	struct REGPACK r;
	struct SREGS sr;
	r.r_ax=9;
	r.r_bx=FP_OFF(mygetmem);
	r.r_es=FP_SEG(mygetmem);
	r.r_cx=FP_OFF(myfreemem);
	r.r_dx=FP_SEG(myfreemem);
	segread(&sr);
	r.r_ds=sr.ds;
	intr(nint,&r);
}

void SetDSMemPtr(void *pt,DWORD size)
{
	struct REGPACK r;
	r.r_ax=10;
	r.r_bx=FP_OFF(pt);
	r.r_es=FP_SEG(pt);
	r.r_cx=(WORD)size;
	r.r_dx=(WORD)(size>>16);
	intr(nint,&r);
}

DWORD GetDSoundMemSize(void)
{
	struct REGPACK r;
	r.r_ax=11;
	intr(nint,&r);
	return (((DWORD)r.r_dx)<<16)|r.r_ax;
}


/* RPMOD */

int StartRPMod(DSOUNDINFO *DS,RPMMODULE *M)
{
	struct REGPACK r;
	r.r_ax=20;
	r.r_bx=FP_OFF(DS);
	r.r_es=FP_SEG(DS);
	r.r_cx=FP_OFF(M);
	r.r_dx=FP_SEG(M);
	intr(nint,&r);
	return r.r_ax;
}


int StopRPMod(void)
{
	struct REGPACK r;
	r.r_ax=21;
	intr(nint,&r);
	return r.r_ax;
}

void SetRPMVoice(WORD voice,WORD vok)
{
	struct REGPACK r;
	r.r_ax=22;
	r.r_bx=voice;
	r.r_cx=vok;
	intr(nint,&r);
}

void SetRPMVolout(WORD vout,WORD bal)
{
	struct REGPACK r;
	r.r_ax=23;
	r.r_bx=vout;
	r.r_cx=bal;
	intr(nint,&r);
}

void SetRPMPattern(WORD pat)
{
	struct REGPACK r;
	r.r_ax=24;
	r.r_bx=pat;
	intr(nint,&r);
}

void GetRPMStatus(RPMSTATUS *RPMS)
{
	struct REGPACK r;
	r.r_ax=25;
	r.r_bx=FP_OFF(RPMS);
	r.r_es=FP_SEG(RPMS);
	intr(nint,&r);
}

/* RPMODIO */

int LoadMod(RPMMODULE *M,char *name)
{
	struct REGPACK r;
	r.r_ax=30;
	r.r_bx=FP_OFF(M);
	r.r_es=FP_SEG(M);
	r.r_cx=FP_OFF(name);
	r.r_dx=FP_SEG(name);
	intr(nint,&r);
	return r.r_ax;
}

void FreeMod(RPMMODULE *M)
{
	struct REGPACK r;
	r.r_ax=31;
	r.r_bx=FP_OFF(M);
	r.r_es=FP_SEG(M);
	intr(nint,&r);
}
